
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="milligrams_of_magnesium", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(lb=0, name="milligrams_of_vitamin_B1", vtype=gurobi.GRB.CONTINUOUS)
x3 = model.addVar(lb=0, name="milligrams_of_vitamin_K", vtype=gurobi.GRB.CONTINUOUS)

# Set the objective function
model.setObjective(3.78*x1 + 8.9*x2 + 5.8*x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(13*x1 + 4*x2 + 6*x3 >= 36, name="immune_support_index_1")
model.addConstr(13*x1 + 4*x2 >= 22, name="immune_support_index_2")
model.addConstr(13*x1 + 4*x2 + 6*x3 >= 53, name="immune_support_index_3")
model.addConstr(6*x1 - 2*x2 >= 0, name="constraint_4")
model.addConstr(3*x2 - 9*x3 >= 0, name="constraint_5")
model.addConstr(13*x1 + 4*x2 <= 89, name="constraint_6")

# Update the model
model.update()

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("Milligrams of magnesium: ", x1.varValue)
    print("Milligrams of vitamin B1: ", x2.varValue)
    print("Milligrams of vitamin K: ", x3.varValue)
else:
    print("The model is infeasible")
