
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(vtype=gp.GRB.INTEGER, name="green_beans")
oranges = m.addVar(vtype=gp.GRB.CONTINUOUS, name="oranges")
slices_pizza = m.addVar(vtype=gp.GRB.INTEGER, name="slices_pizza")


# Set objective function
m.setObjective(3.42 * green_beans * oranges + 7.77 * oranges * slices_pizza + 6.09 * slices_pizza**2 + 3.32 * green_beans + 2.66 * oranges, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * green_beans + 16 * oranges + 20 * slices_pizza <= 107, "dollar_cost")
m.addConstr(5 * green_beans + 16 * oranges + 7 * slices_pizza <= 113, "tastiness_rating")
m.addConstr(green_beans**2 + slices_pizza**2 >= 21, "c1")
m.addConstr(oranges**2 + slices_pizza**2 >= 23, "c2")
m.addConstr(4 * green_beans + 16 * oranges >= 11, "c3")
m.addConstr(4 * green_beans + 16 * oranges + 20 * slices_pizza >= 23, "c4")
m.addConstr(5 * green_beans + 16 * oranges >= 37, "c5")
m.addConstr(16 * oranges + 7 * slices_pizza >= 20, "c6")
m.addConstr(5 * green_beans + 16 * oranges + 7 * slices_pizza >= 25, "c7")
m.addConstr(2 * green_beans - 10 * slices_pizza >= 0, "c8")
m.addConstr(5 * green_beans + 7 * slices_pizza <= 68, "c9")
m.addConstr((16*oranges)**2 + (7*slices_pizza)**2 <= 99, "c10")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('green_beans:', green_beans.x)
    print('oranges:', oranges.x)
    print('slices_pizza:', slices_pizza.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

