
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    zucchini = m.addVar(vtype=gp.GRB.INTEGER, name="zucchini")
    cucumber = m.addVar(vtype=gp.GRB.INTEGER, name="cucumber")


    # Set objective function
    m.setObjective(2.44 * zucchini + 6.82 * cucumber, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * zucchini + 15 * cucumber >= 66, "resilience_lower")
    m.addConstr(6 * zucchini + cucumber >= 66, "space_lower")
    m.addConstr(8 * zucchini - 3 * cucumber >= 0, "zv_cuke_relation")
    m.addConstr(8 * zucchini + 15 * cucumber <= 159, "resilience_upper")
    m.addConstr(6 * zucchini + cucumber <= 172, "space_upper")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('zucchini vines:', zucchini.x)
        print('cucumber vines:', cucumber.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

