
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="zucchini_vines")
x1 = m.addVar(vtype=GRB.INTEGER, name="cucumber_vines")

# Set the objective function
m.setObjective(2.44*x0 + 6.82*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x0 + 15*x1 >= 66, "Resilience_Index_Lower_Bound")
m.addConstr(6*x0 + x1 >= 66, "Planting_Space_Lower_Bound")
m.addConstr(8*x0 - 3*x1 >= 0, "Vine_Relation_Constraint")
m.addConstr(8*x0 + 15*x1 <= 159, "Resilience_Index_Upper_Bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Zucchini Vines: {x0.x}")
    print(f"Cucumber Vines: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
