
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="zucchini_vines", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cucumber_vines", vtype=gurobi.GRB.INTEGER)

    # Objective function: minimize 2.44*x1 + 6.82*x2
    model.setObjective(2.44*x1 + 6.82*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x1 + 15*x2 >= 66, name="resilience_index_min")
    model.addConstr(6*x1 + x2 >= 66, name="planting_space_min")
    model.addConstr(8*x1 - 3*x2 >= 0, name="linear_combination")
    model.addConstr(8*x1 + 15*x2 <= 159, name="resilience_index_max")
    model.addConstr(6*x1 + x2 <= 172, name="planting_space_max")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Zucchini vines: {x1.varValue}")
        print(f"Cucumber vines: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
