
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by Peggy
    x1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Hank
    x2 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")  # hours worked by George


    # Set objective function
    model.setObjective(8*x0*x1 + x2**2 + x0, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(8*x1**2 + 6*x2**2 >= 28, "c0")
    model.addConstr(x0 + 8*x1 + 6*x2 >= 28, "c1")
    model.addConstr(2*x1 + 3*x2 >= 23, "c2")
    model.addConstr(x0**2 + 3*x2**2 >= 24, "c3")
    model.addConstr(x0**2 + 2*x1**2 + 3*x2**2 >= 21, "c4")
    model.addConstr(x0 + 2*x1 + 3*x2 >= 21, "c5")
    model.addConstr(9*x0**2 - 7*x1**2 >= 0, "c6")
    model.addConstr(x0 + 3*x2 <= 79, "c7")
    model.addConstr(2*x1**2 + 3*x2**2 <= 58, "c8")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
