
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Peggy
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Hank
    x2 = model.addVar(name="x2", lb=0)  # hours worked by George

    # Objective function
    model.setObjective(8 * x0 * x1 + x2 ** 2 + x0, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 ** 2 + x2 ** 2 >= 28)
    model.addConstr(x0 + x1 + x2 >= 28)
    model.addConstr(x1 + x2 >= 23)
    model.addConstr(x0 ** 2 + x2 ** 2 >= 24)
    model.addConstr(x0 ** 2 + x1 ** 2 + x2 ** 2 >= 21)
    model.addConstr(x0 + x1 + x2 >= 21)
    model.addConstr(9 * x0 ** 2 - 7 * x1 ** 2 >= 0)
    model.addConstr(x0 + x2 <= 79)
    model.addConstr(x1 ** 2 + x2 ** 2 <= 58)

    # Optimize
    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Peggy: {x0.varValue}")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by George: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
