
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("storage_optimization")

    # Create variables
    napkins = m.addVar(vtype=gp.GRB.INTEGER, name="napkins")
    dish_soap = m.addVar(vtype=gp.GRB.INTEGER, name="dish_soap")
    paper_towels = m.addVar(vtype=gp.GRB.INTEGER, name="paper_towels")
    toilet_paper = m.addVar(vtype=gp.GRB.INTEGER, name="toilet_paper")

    # Set objective function
    m.setObjective(10.0 * napkins + 6.84 * dish_soap + 5.05 * paper_towels + 1.44 * toilet_paper, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8 * napkins + 4 * dish_soap + 3 * paper_towels + 6 * toilet_paper <= 97, "storage_space")
    m.addConstr(3 * paper_towels + 6 * toilet_paper >= 14, "paper_toilet_space")
    m.addConstr(4 * dish_soap + 3 * paper_towels >= 18, "dish_paper_space")
    m.addConstr(8 * napkins + 3 * paper_towels >= 24, "napkins_paper_space")
    m.addConstr(8 * napkins + 4 * dish_soap >= 11, "napkins_dish_space")
    m.addConstr(8 * napkins + 4 * dish_soap + 3 * paper_towels + 6 * toilet_paper >= 11, "total_space_used")
    m.addConstr(-7 * napkins + 8 * paper_towels >= 0, "napkins_paper_relation")
    m.addConstr(8 * napkins + 4 * dish_soap <= 62, "napkins_dish_space_upper")
    m.addConstr(8 * napkins + 4 * dish_soap + 3 * paper_towels <= 73, "napkins_dish_paper_space_upper")
    m.addConstr(8 * napkins + 4 * dish_soap + 6 * toilet_paper <= 96, "napkins_dish_toilet_space_upper")
    m.addConstr(4 * dish_soap + 3 * paper_towels + 6 * toilet_paper <= 59, "dish_paper_toilet_space_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('Napkins:', napkins.x)
        print('Dish Soap:', dish_soap.x)
        print('Paper Towels:', paper_towels.x)
        print('Toilet Paper:', toilet_paper.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
