
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='packs_of_napkins', vtype=gurobi.GRB.INTEGER, lb=0)
    x2 = model.addVar(name='dish_soap_bottles', vtype=gurobi.GRB.INTEGER, lb=0)
    x3 = model.addVar(name='paper_towel_rolls', vtype=gurobi.GRB.INTEGER, lb=0)
    x4 = model.addVar(name='toilet_paper_rolls', vtype=gurobi.GRB.INTEGER, lb=0)

    # Objective function
    model.setObjective(10.0*x1 + 6.84*x2 + 5.05*x3 + 1.44*x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8*x1 + 4*x2 + 3*x3 + 6*x4 <= 97)
    model.addConstr(8*x1 >= 24)
    model.addConstr(8*x1 + 3*x3 >= 24)
    model.addConstr(4*x2 + 3*x3 >= 18)
    model.addConstr(8*x1 + 6*x4 >= 11)
    model.addConstr(8*x1 + 4*x2 + 3*x3 + 6*x4 >= 11)
    model.addConstr(-7*x1 + 8*x3 >= 0)
    model.addConstr(8*x1 + 4*x2 <= 62)
    model.addConstr(8*x1 + 4*x2 + 3*x3 <= 73)
    model.addConstr(8*x1 + 4*x2 + 6*x4 <= 96)
    model.addConstr(4*x2 + 3*x3 + 6*x4 <= 59)
    model.addConstr(3*x3 + 6*x4 >= 14)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('packs_of_napkins: ', x1.varValue)
        print('dish_soap_bottles: ', x2.varValue)
        print('paper_towel_rolls: ', x3.varValue)
        print('toilet_paper_rolls: ', x4.varValue)
    else:
        print('No optimal solution found')

solve_optimization_problem()
