
import gurobipy as gp

# Create a new model
model = gp.Model("Work_Optimization")

# Create variables
paul = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Paul")
bobby = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Bobby")
peggy = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Peggy")
jean = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="Jean")
dale = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="Dale")


# Set objective function
model.setObjective(8*paul + 6*bobby + 2*peggy + 5*jean + 3*dale, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(11*paul + 14*bobby + 10*peggy >= 32, "c0")
model.addConstr(11*paul + 10*peggy <= 123, "c1")
model.addConstr(14*bobby + 5*dale <= 87, "c2")
model.addConstr(14*bobby + 10*peggy <= 151, "c3")
model.addConstr(10*peggy + 5*dale <= 143, "c4")
model.addConstr(11*paul + 5*dale <= 125, "c5")
model.addConstr(11*paul + 10*jean + 5*dale <= 82, "c6")
model.addConstr(11*paul + 14*bobby + 10*peggy + 10*jean + 5*dale <= 82, "c7")
model.addConstr(14*bobby + 10*jean <= 221, "c8")
model.addConstr(10*jean + 1*dale <= 326, "c9")
model.addConstr(12*paul + 14*bobby + 11*peggy + 10*jean + 1*dale <= 326, "c10")
model.addConstr(6*paul + 7*jean <= 77, "c11")
model.addConstr(3*peggy + 7*jean <= 62, "c12")
model.addConstr(7*jean + 8*dale <= 75, "c13")
model.addConstr(6*paul + 3*peggy <= 84, "c14")
model.addConstr(6*bobby + 3*peggy <= 37, "c15")
model.addConstr(6*paul + 8*dale <= 60, "c16")
model.addConstr(3*peggy + 7*jean + 8*dale <= 40, "c17")
model.addConstr(6*bobby + 3*peggy + 8*dale <= 77, "c18")
model.addConstr(6*bobby + 3*peggy + 7*jean <= 76, "c19")
model.addConstr(6*paul + 3*peggy + 8*dale <= 52, "c20")
model.addConstr(6*paul + 3*peggy + 7*jean <= 33, "c21")
model.addConstr(6*bobby + 7*jean + 8*dale <= 17, "c22")
model.addConstr(6*paul + 6*bobby + 3*peggy + 7*jean + 8*dale <= 17, "c23")


# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Paul: {paul.x}")
    print(f"Bobby: {bobby.x}")
    print(f"Peggy: {peggy.x}")
    print(f"Jean: {jean.x}")
    print(f"Dale: {dale.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

