
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Paul
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Peggy
    x3 = model.addVar(name="x3", lb=0, integrality=1)  # hours worked by Jean
    x4 = model.addVar(name="x4", lb=0)  # hours worked by Dale

    # Objective function
    model.setObjective(8 * x0 + 6 * x1 + 2 * x2 + 5 * x3 + 3 * x4, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(11 * x0 <= 11)
    model.addConstr(12 * x0 <= 12)
    model.addConstr(6 * x0 <= 6)
    model.addConstr(14 * x1 <= 14)
    model.addConstr(14 * x1 <= 14)
    model.addConstr(6 * x1 <= 6)
    model.addConstr(10 * x2 <= 10)
    model.addConstr(11 * x2 <= 11)
    model.addConstr(3 * x2 <= 3)
    model.addConstr(10 * x3 <= 10)
    model.addConstr(10 * x3 <= 10)
    model.addConstr(7 * x3 <= 7)
    model.addConstr(5 * x4 <= 5)
    model.addConstr(1 * x4 <= 1)
    model.addConstr(8 * x4 <= 8)
    model.addConstr(11 * x0 + 14 * x1 + 10 * x2 >= 32)
    model.addConstr(11 * x0 + 10 * x2 <= 123)
    model.addConstr(14 * x1 + 5 * x4 <= 87)
    model.addConstr(14 * x1 + 10 * x2 <= 151)
    model.addConstr(10 * x2 + 5 * x4 <= 143)
    model.addConstr(11 * x0 + 5 * x4 <= 125)
    model.addConstr(11 * x0 + 10 * x3 + 5 * x4 <= 82)
    model.addConstr(11 * x0 + 14 * x1 + 10 * x2 + 10 * x3 + 5 * x4 <= 82)
    model.addConstr(14 * x1 + 10 * x3 <= 221)
    model.addConstr(10 * x3 + 1 * x4 <= 326)
    model.addConstr(12 * x0 + 14 * x1 + 11 * x2 + 10 * x3 + 1 * x4 <= 326)
    model.addConstr(6 * x0 + 7 * x3 <= 77)
    model.addConstr(3 * x2 + 7 * x3 <= 62)
    model.addConstr(7 * x3 + 8 * x4 <= 75)
    model.addConstr(6 * x0 + 3 * x2 <= 84)
    model.addConstr(6 * x1 + 3 * x2 <= 37)
    model.addConstr(6 * x0 + 8 * x4 <= 60)
    model.addConstr(3 * x2 + 7 * x3 + 8 * x4 <= 40)
    model.addConstr(6 * x1 + 3 * x2 + 8 * x4 <= 77)
    model.addConstr(6 * x1 + 3 * x2 + 7 * x3 <= 76)
    model.addConstr(6 * x0 + 3 * x2 + 8 * x4 <= 52)
    model.addConstr(6 * x0 + 3 * x2 + 7 * x3 <= 33)
    model.addConstr(6 * x1 + 7 * x3 + 8 * x4 <= 17)
    model.addConstr(6 * x0 + 6 * x1 + 3 * x2 + 7 * x3 + 8 * x4 <= 17)

    model.optimize()

    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Hours worked by Paul: ", x0.varValue)
        print("Hours worked by Bobby: ", x1.varValue)
        print("Hours worked by Peggy: ", x2.varValue)
        print("Hours worked by Jean: ", x3.varValue)
        print("Hours worked by Dale: ", x4.varValue)
    else:
        print("The problem is infeasible")

optimize_problem()
