
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bowls of cereal")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter sandwiches")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie chickens")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")


# Set objective function
m.setObjective(5*x0 + 1*x1 + 6*x2 + 9*x3 + 7*x4, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(1.75*x1 + 1.88*x4 >= 14)
m.addConstr(0.12*x0 + 1.88*x4 >= 21)
m.addConstr(0.12*x0 + 0.18*x3 >= 23)
m.addConstr(0.12*x0 + 1.75*x1 >= 32)
m.addConstr(1.66*x2 + 0.18*x3 + 1.88*x4 >= 33)
m.addConstr(0.12*x0 + 1.75*x1 + 1.66*x2 + 0.18*x3 + 1.88*x4 >= 33)
m.addConstr(0.13*x0 + 0.97*x4 >= 42)
m.addConstr(0.04*x3 + 0.97*x4 >= 35)
m.addConstr(1.43*x2 + 0.04*x3 >= 35)
m.addConstr(0.75*x1 + 0.97*x4 >= 31)
m.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 >= 44)
m.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 >= 44)
m.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 >= 42)
m.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 >= 42)
m.addConstr(0.13*x0 + 0.75*x1 + 1.43*x2 + 0.04*x3 + 0.97*x4 >= 42)
m.addConstr(5*x2 - 6*x3 >= 0)
m.addConstr(-5*x1 + 1*x3 >= 0)
m.addConstr(10*x0 + 10*x3 - 4*x4 >= 0)
m.addConstr(0.12*x0 + 1.88*x4 <= 110)
m.addConstr(1.75*x1 + 0.18*x3 + 1.88*x4 <= 89)
m.addConstr(1.75*x1 + 1.66*x2 + 0.18*x3 <= 166)
m.addConstr(1.75*x1 + 1.66*x2 + 1.88*x4 <= 50)
m.addConstr(0.12*x0 + 1.75*x1 + 0.18*x3 <= 55)
m.addConstr(0.12*x0 + 1.66*x2 + 1.88*x4 <= 74)
m.addConstr(0.13*x0 + 0.75*x1 + 0.97*x4 <= 226)
m.addConstr(0.75*x1 + 1.43*x2 + 0.97*x4 <= 196)
m.addConstr(0.13*x0 + 0.04*x3 + 0.97*x4 <= 82)
m.addConstr(1.43*x2 + 0.04*x3 + 0.97*x4 <= 152)



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

