
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x0")  # bowls of cereal
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x1")  # peanutbutter sandwiches
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x2")  # apples
    x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x3")  # rotisserie chickens
    x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="x4")  # oreos

    # Objective function
    model.setObjective(5 * x0 + x1 + 6 * x2 + 9 * x3 + 7 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1.75 * x1 + 1.88 * x4 >= 14)
    model.addConstr(0.12 * x0 + 1.88 * x4 >= 21)
    model.addConstr(0.12 * x0 + 0.18 * x3 >= 23)
    model.addConstr(0.12 * x0 + 1.75 * x1 >= 32)
    model.addConstr(1.66 * x2 + 0.18 * x3 + 1.88 * x4 >= 33)
    model.addConstr(0.12 * x0 + 1.75 * x1 + 1.66 * x2 + 0.18 * x3 + 1.88 * x4 >= 33)
    model.addConstr(0.13 * x0 + 0.97 * x4 >= 42)
    model.addConstr(0.04 * x3 + 0.97 * x4 >= 35)
    model.addConstr(1.43 * x2 + 0.04 * x3 >= 35)
    model.addConstr(0.75 * x1 + 0.97 * x4 >= 31)
    model.addConstr(0.13 * x0 + 0.04 * x3 + 0.97 * x4 >= 44)
    model.addConstr(0.13 * x0 + 0.75 * x1 + 1.43 * x2 >= 44)
    model.addConstr(0.13 * x0 + 0.04 * x3 + 0.97 * x4 >= 42)
    model.addConstr(0.13 * x0 + 0.75 * x1 + 1.43 * x2 >= 42)
    model.addConstr(0.13 * x0 + 0.75 * x1 + 1.43 * x2 + 0.04 * x3 + 0.97 * x4 >= 42)
    model.addConstr(5 * x2 - 6 * x3 >= 0)
    model.addConstr(-5 * x1 + x3 >= 0)
    model.addConstr(10 * x0 + 10 * x3 - 4 * x4 >= 0)
    model.addConstr(0.12 * x0 + 1.88 * x4 <= 110)
    model.addConstr(1.75 * x1 + 0.18 * x3 + 1.88 * x4 <= 89)
    model.addConstr(1.75 * x1 + 1.66 * x2 + 0.18 * x3 <= 166)
    model.addConstr(1.75 * x1 + 1.66 * x2 + 1.88 * x4 <= 50)
    model.addConstr(0.12 * x0 + 1.75 * x1 + 0.18 * x3 <= 55)
    model.addConstr(0.12 * x0 + 1.66 * x2 + 1.88 * x4 <= 74)
    model.addConstr(0.13 * x0 + 0.75 * x1 + 0.97 * x4 <= 226)
    model.addConstr(0.75 * x1 + 1.43 * x2 + 0.97 * x4 <= 196)
    model.addConstr(0.13 * x0 + 0.04 * x3 + 0.97 * x4 <= 82)
    model.addConstr(1.43 * x2 + 0.04 * x3 + 0.97 * x4 <= 152)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
