
import gurobi as gp

# Define variables
x0 = gp.Var(name="x0", lb=0) # grams of fat
x1 = gp.Var(name="x1", lb=0) # milligrams of vitamin B3
x2 = gp.Var(name="x2", lb=0, type=gp.GRB.INTEGER) # milligrams of vitamin B1
x3 = gp.Var(name="x3", lb=0, type=gp.GRB.INTEGER) # milligrams of vitamin B6
x4 = gp.Var(name="x4", lb=0) # milligrams of calcium
x5 = gp.Var(name="x5", lb=0, type=gp.GRB.INTEGER) # milligrams of vitamin E
x6 = gp.Var(name="x6", lb=0) # milligrams of vitamin B12
x7 = gp.Var(name="x7", lb=0) # milligrams of vitamin B9

# Create model
m = gp.Model()

# Objective function
m.setObjective(x0 + x1 + 8*x2 + 7*x3 + x4 + 2*x5 + 3*x6 + 5*x7, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(10*x0 + 5*x1 + 6*x2 + 4*x3 + x4 + 10*x5 + 7*x6 + 6*x7 <= 238)
m.addConstr(3*x0 + 5*x1 + 6*x2 + 3*x3 + 9*x4 + x5 + 5*x6 + 9*x7 <= 165)
m.addConstr(7*x0 + 3*x1 + 2*x2 + 3*x3 + 2*x4 + 9*x5 + 9*x6 + 8*x7 <= 247)
m.addConstr(5*x1 + 6*x2 + 4*x3 + x4 + 10*x5 + 7*x6 + 6*x7 >= 9)
m.addConstr(x4 + 6*x7 >= 27)
m.addConstr(10*x5 + 6*x7 >= 14)
m.addConstr(10*x0 + x4 >= 19)
m.addConstr(5*x1 + 6*x7 >= 9)
m.addConstr(4*x3 + 10*x5 >= 15)
m.addConstr(5*x1 + x5 >= 12)
m.addConstr(5*x1 + x4 >= 16)
m.addConstr(6*x2 + 4*x3 >= 22)
m.addConstr(6*x2 + 6*x7 >= 9)
m.addConstr(10*x0 + 5*x1 >= 9)
m.addConstr(10*x0 + x1 + x5 >= 14)

# Solve model
m.optimize()

if m.status == gp.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
    print("x6: ", x6.varValue)
    print("x7: ", x7.varValue)
else:
    print("The model is infeasible")
