
import gurobipy as gp

# Create a new model
m = gp.Model("vitamin_optimization")

# Create variables
vitamin_a = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_a")
vitamin_k = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_k")
vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")


# Set objective function
m.setObjective(1.0 * vitamin_a + 7.79 * vitamin_k + 9.88 * vitamin_c, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(9 * vitamin_a + 1 * vitamin_k >= 44)
m.addConstr(9 * vitamin_a + 10 * vitamin_c >= 68)
m.addConstr(9 * vitamin_a + 1 * vitamin_k + 10 * vitamin_c >= 68)
m.addConstr(16 * vitamin_a + 11 * vitamin_c >= 53)
m.addConstr(15 * vitamin_k + 11 * vitamin_c >= 30)
m.addConstr(16 * vitamin_a + 15 * vitamin_k + 11 * vitamin_c >= 30)
m.addConstr(6 * vitamin_a + 6 * vitamin_c >= 39)
m.addConstr(15 * vitamin_k + 6 * vitamin_c >= 46)
m.addConstr(6 * vitamin_a + 15 * vitamin_k + 6 * vitamin_c >= 46)
m.addConstr(5 * vitamin_k + 14 * vitamin_c >= 25)
m.addConstr(14 * vitamin_a + 5 * vitamin_k >= 35)
m.addConstr(14 * vitamin_a + 14 * vitamin_c >= 40)
m.addConstr(14 * vitamin_a + 5 * vitamin_k + 14 * vitamin_c >= 40)
m.addConstr(15 * vitamin_a + 15 * vitamin_k >= 25)
m.addConstr(15 * vitamin_a + 8 * vitamin_c >= 24)
m.addConstr(15 * vitamin_a + 15 * vitamin_k + 8 * vitamin_c >= 24)
m.addConstr(-4 * vitamin_a + 2 * vitamin_k >= 0)
m.addConstr(10 * vitamin_a - 8 * vitamin_c >= 0)
m.addConstr(9 * vitamin_a + 10 * vitamin_c <= 211)
m.addConstr(1 * vitamin_k + 10 * vitamin_c <= 140)
m.addConstr(9 * vitamin_a + 1 * vitamin_k <= 213)
m.addConstr(16 * vitamin_a + 11 * vitamin_c <= 172)
m.addConstr(6 * vitamin_a + 6 * vitamin_c <= 89)
m.addConstr(6 * vitamin_a + 15 * vitamin_k + 6 * vitamin_c <= 147)
m.addConstr(5 * vitamin_k + 14 * vitamin_c <= 170)
m.addConstr(14 * vitamin_a + 5 * vitamin_k + 14 * vitamin_c <= 172)
m.addConstr(15 * vitamin_a + 15 * vitamin_k <= 49)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('vitamin_a:', vitamin_a.x)
    print('vitamin_k:', vitamin_k.x)
    print('vitamin_c:', vitamin_c.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

