
import gurobi

def optimize_vitamins():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin A
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin K
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin C

    # Objective function
    model.setObjective(1.0*x0 + 7.79*x1 + 9.88*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(9*x0 <= 261)
    model.addConstr(16*x0 <= 239)
    model.addConstr(6*x0 <= 148)
    model.addConstr(14*x0 <= 176)
    model.addConstr(15*x0 <= 101)
    model.addConstr(1*x1 <= 261)
    model.addConstr(15*x1 <= 239)
    model.addConstr(15*x1 <= 148)
    model.addConstr(5*x1 <= 176)
    model.addConstr(15*x1 <= 101)
    model.addConstr(10*x2 <= 261)
    model.addConstr(11*x2 <= 239)
    model.addConstr(6*x2 <= 148)
    model.addConstr(14*x2 <= 176)
    model.addConstr(8*x2 <= 101)
    model.addConstr(9*x0 + 1*x1 >= 44)
    model.addConstr(9*x0 + 10*x2 >= 68)
    model.addConstr(9*x0 + 1*x1 + 10*x2 >= 68)
    model.addConstr(16*x0 + 11*x2 >= 53)
    model.addConstr(15*x1 + 11*x2 >= 30)
    model.addConstr(16*x0 + 15*x1 + 11*x2 >= 30)
    model.addConstr(6*x0 + 6*x2 >= 39)
    model.addConstr(15*x1 + 6*x2 >= 46)
    model.addConstr(6*x0 + 15*x1 + 6*x2 >= 46)
    model.addConstr(5*x1 + 14*x2 >= 25)
    model.addConstr(14*x0 + 5*x1 >= 35)
    model.addConstr(14*x0 + 14*x2 >= 40)
    model.addConstr(14*x0 + 5*x1 + 14*x2 >= 40)
    model.addConstr(15*x0 + 15*x1 >= 25)
    model.addConstr(15*x0 + 8*x2 >= 24)
    model.addConstr(15*x0 + 15*x1 + 8*x2 >= 24)
    model.addConstr(-4*x0 + 2*x1 >= 0)
    model.addConstr(10*x0 - 8*x2 >= 0)
    model.addConstr(9*x0 + 10*x2 <= 211)
    model.addConstr(1*x1 + 10*x2 <= 140)
    model.addConstr(9*x0 + 1*x1 <= 213)
    model.addConstr(16*x0 + 11*x2 <= 172)
    model.addConstr(6*x0 + 6*x2 <= 89)
    model.addConstr(6*x0 + 15*x1 + 6*x2 <= 147)
    model.addConstr(5*x1 + 14*x2 <= 170)
    model.addConstr(14*x0 + 5*x1 + 14*x2 <= 172)
    model.addConstr(15*x0 + 15*x1 <= 49)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x0.varValue}")
        print(f"Milligrams of vitamin K: {x1.varValue}")
        print(f"Milligrams of vitamin C: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_vitamins()
