
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0")  # hours worked by George
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1")  # hours worked by Paul
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x2")  # hours worked by Laura


# Set objective function
m.setObjective(x0*x1 + 9*x0*x2 + x1*x2 + 2*x2*x2 + 9*x0 + 8*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(29*x0 + 23*x1 <= 208, "c1")
m.addConstr(29*x0 + 25*x2 <= 106, "c2")
m.addConstr(29*x0 + 23*x1 + 25*x2 <= 268, "c3")
m.addConstr(23*x1*x1 + 25*x2*x2 <= 266, "c4")
m.addConstr(29*x0*x0 + 23*x1*x1 + 25*x2*x2 <= 268, "c5")


# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

