
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x1 = m.addVar(lb=0, name="hours_worked_by_George")
x2 = m.addVar(lb=0, name="hours_worked_by_Paul")
x3 = m.addVar(lb=0, name="hours_worked_by_Laura")

# Set the objective function
m.setObjective(1*x1*x2 + 9*x1*x3 + 1*x2*x3 + 2*x3**2 + 9*x1 + 8*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(29*x1 <= 284)
m.addConstr(23*x2 <= 284)
m.addConstr(25*x3 <= 284)
m.addConstr(529*x2**2 + 625*x3**2 <= 266)
m.addConstr(29*x1 + 23*x2 <= 208)
m.addConstr(29*x1 + 25*x3 <= 106)
m.addConstr(841*x1**2 + 529*x2**2 + 625*x3**2 <= 268)
m.addConstr(29*x1 + 23*x2 + 25*x3 <= 268)

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by George: {x1.x}")
    print(f"Hours worked by Paul: {x2.x}")
    print(f"Hours worked by Laura: {x3.x}")
else:
    print("No optimal solution found")
