
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="hours_worked_by_George", lb=0)
x1 = m.addVar(name="hours_worked_by_Paul", lb=0)
x2 = m.addVar(name="hours_worked_by_Laura", lb=0)

# Objective function
m.setObjective(x0*x1 + 9*x0*x2 + x1*x2 + 2*x2**2 + 9*x0 + 8*x1, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(23*x1 + 25*x2 <= 266)
m.addConstr(29*x0 + 23*x1 <= 208)
m.addConstr(29*x0 + 25*x2 <= 106)
m.addConstr(x0**2 + x1**2 + x2**2 <= 268)
m.addConstr(29*x0 + 23*x1 + 25*x2 <= 268)

# Update model
m.update()

# Optimize model
m.optimize()

# Print solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Hours worked by George: ", x0.varValue)
    print("Hours worked by Paul: ", x1.varValue)
    print("Hours worked by Laura: ", x2.varValue)
else:
    print("No optimal solution found")
