
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="corn_cobs")
    x1 = model.addVar(vtype=GRB.CONTINUOUS, name="black_beans")

    # Set objective function
    model.setObjective(9*x0**2 + 9*x0*x1 + 4*x1**2 + 9*x0 + 8*x1, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(7*x0 + 6*x1 <= 41, "dollar_cost")
    model.addConstr(1*x0 + 4*x1 <= 24, "umami_index")
    model.addConstr(5*x0 + 7*x1 <= 76, "grams_of_fat")
    model.addConstr(7*x0 + 2*x1 <= 88, "grams_of_fiber")
    model.addConstr(4*x0 + 4*x1 <= 42, "sourness_index")
    model.addConstr(x0**2 + x1**2 >= 6, "cost_squared")
    model.addConstr(x0 + 4*x1 >= 12, "umami_index_min")
    model.addConstr(5*x0 + 7*x1 >= 20, "fat_min")
    model.addConstr(7*x0 + 2*x1 >= 39, "fiber_min")
    model.addConstr(4*x0**2 + 4*x1**2 >= 17, "sourness_squared_min")
    model.addConstr(-4*x0 + x1 >= 0, "linear_constraint")
    model.addConstr(7*x0 + 6*x1 <= 22, "dollar_cost_max1")
    model.addConstr(x0 + 4*x1 <= 16, "umami_index_max1")
    model.addConstr(5*x0 + 7*x1 <= 54, "fat_max1")
    model.addConstr(7*x0 + 2*x1 <= 71, "fiber_max1")
    model.addConstr(4*x0**2 + 4*x1**2 <= 27, "sourness_squared_max")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print("Optimal solution found:")
        print(f"corn_cobs: {x0.x}")
        print(f"black_beans: {x1.x}")
        print(f"Objective value: {model.objVal}")
    elif model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {model.status}")

except gp.GrorbiError as e:
    print(f"Error code {e.errno}: {e.message}")

except AttributeError:
    print('Encountered an attribute error')
