
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name='corn_cobs', vtype='I')  # Integer variable for corn cobs
x2 = m.addVar(name='black_beans')  # Continuous variable for black beans

# Objective function
m.setObjective(9*x1**2 + 9*x1*x2 + 4*x2**2 + 9*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x1 + 6*x2 <= 41)  # Cost constraint
m.addConstr(x1**2 + x2**2 >= 6)  # Cost squared constraint
m.addConstr(x1 + 4*x2 >= 12)  # Umami index constraint
m.addConstr(5*x1 + 7*x2 >= 20)  # Fat constraint
m.addConstr(7*x1 + 2*x2 >= 39)  # Fiber constraint
m.addConstr(4*(x1**2 + x2**2) >= 17)  # Sourness index squared constraint
m.addConstr(-4*x1 + x2 >= 0)  # Linear constraint
m.addConstr(x1 + 4*x2 <= 16)  # Umami index upper bound
m.addConstr(5*x1 + 7*x2 <= 54)  # Fat upper bound
m.addConstr(7*x1 + 2*x2 <= 71)  # Fiber upper bound
m.addConstr(4*(x1**2 + x2**2) <= 27)  # Sourness index squared upper bound
m.addConstr(4*x1 + 4*x2 <= 27)  # Sourness index upper bound

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Corn Cobs: ', x1.varValue)
    print('Black Beans: ', x2.varValue)
else:
    print('No solution found')
