
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # hours worked by Paul
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # hours worked by Hank


    # Set objective function
    model.setObjective(8*x0 + 8*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14.64*x0 + 0.84*x1 >= 58, "c1")
    model.addConstr(7.43*x0 + 6.44*x1 >= 85, "c2")
    model.addConstr(22.05*x0 + 15.58*x1 >= 107, "c3")
    model.addConstr(2.11*x0 + 20.34*x1 >= 93, "c4")
    model.addConstr(7.51*x0 + 9.68*x1 >= 94, "c5")
    model.addConstr(x0 - 8*x1 >= 0, "c6")
    model.addConstr(14.64*x0 + 0.84*x1 <= 157, "c7")
    model.addConstr(7.43*x0 + 6.44*x1 <= 144, "c8")
    model.addConstr(22.05*x0 + 15.58*x1 <= 242, "c9")
    model.addConstr(2.11*x0 + 20.34*x1 <= 344, "c10")
    model.addConstr(7.51*x0 + 9.68*x1 <= 309, "c11")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
