
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Paul", lb=0)
    x2 = model.addVar(name="hours_worked_by_Hank", lb=0)

    # Define the objective function
    model.setObjective(8*x1 + 8*x2, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(14.64*x1 + 0.84*x2 >= 58)
    model.addConstr(7.43*x1 + 6.44*x2 >= 85)
    model.addConstr(22.05*x1 + 15.58*x2 >= 107)
    model.addConstr(2.11*x1 + 20.34*x2 >= 93)
    model.addConstr(7.51*x1 + 9.68*x2 >= 94)
    model.addConstr(x1 - 8*x2 >= 0)
    model.addConstr(14.64*x1 + 0.84*x2 <= 157)
    model.addConstr(7.43*x1 + 6.44*x2 <= 144)
    model.addConstr(22.05*x1 + 15.58*x2 <= 242)
    model.addConstr(2.11*x1 + 20.34*x2 <= 344)
    model.addConstr(7.51*x1 + 9.68*x2 <= 309)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x1.x}")
        print(f"Hours worked by Hank: {x2.x}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
