
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of potassium
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of carbohydrates
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of calcium
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of vitamin D


    # Set objective function
    m.setObjective(2*x0**2 + 6*x0*x1 + 6*x0*x2 + x0*x3 + 7*x1*x2 + 6*x1*x3 + 4*x2**2 + 4*x2*x3 + 9*x3**2 + 9*x0 + x1 + 8*x2 + 6*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16*x0 + 15*x1 + 16*x2 + 13*x3 <= 248)
    m.addConstr(3*x0 + 11*x1 + 2*x2 + 9*x3 <= 278)
    m.addConstr(15*x1 + 16*x2 >= 56)
    m.addConstr(16*x0 + 13*x3 >= 48)
    m.addConstr(16*x0 + 15*x1 >= 53)
    m.addConstr(15*x1 + 13*x3 >= 59)
    m.addConstr(16*x2 + 13*x3 >= 25)
    m.addConstr(16*x0 + 15*x1 + 16*x2 + 13*x3 >= 25)
    m.addConstr(11*x1**2 + 9*x3**2 >= 34)
    m.addConstr(3*x0 + 11*x1 >= 38)
    m.addConstr(3*x0 + 11*x1 + 2*x2 + 9*x3 >= 38)
    m.addConstr(15*x1 + 16*x2 <= 142)
    m.addConstr(16*x2 + 13*x3 <= 248)
    m.addConstr(15*x1**2 + 13*x3**2 <= 67)
    m.addConstr(16*x0 + 15*x1 <= 229)
    m.addConstr(16*x0 + 13*x3 <= 205)
    m.addConstr(3*x0**2 + 11*x1**2 + 9*x3**2 <= 132)
    m.addConstr(11*x1**2 + 2*x2**2 + 9*x3**2 <= 188)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        for v in m.getVars():
            print(f'{v.varName}: {v.x}')
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
