
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    iron = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="iron")
    potassium = m.addVar(lb=0, vtype=GRB.INTEGER, name="potassium")


    # Set objective function
    m.setObjective(5*iron**2 + 4*iron*potassium + 3*potassium**2 + 8*iron + 7*potassium, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(2*iron + 9*potassium >= 48, "c0")
    m.addConstr(2*iron + 9*potassium <= 56, "c1")
    m.addConstr(10*iron + 3*potassium >= 18, "c2")
    m.addConstr(10*iron + 3*potassium <= 55, "c3")
    m.addConstr(-6*iron + 5*potassium >= 0, "c4")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Optimal iron: {iron.x}")
        print(f"Optimal potassium: {potassium.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
