
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, name="milligrams_of_iron")
x2 = m.addVar(vtype=GRB.INTEGER, lb=0, name="milligrams_of_potassium")

# Set the objective function
m.setObjective(5*x1**2 + 4*x1*x2 + 3*x2**2 + 8*x1 + 7*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(x1**2 + x2**2 >= 48, name="immune_support_index_combined")
m.addConstr(x1 + x2 >= 48, name="total_immune_support_index")
m.addConstr(10*x1 + 3*x2 >= 18, name="muscle_growth_index_combined")
m.addConstr(-6*x1 + 5*x2 >= 0, name="iron_potassium_ratio")
m.addConstr(x1 + x2 <= 56, name="max_total_immune_support_index")
m.addConstr(10*x1 + 3*x2 <= 55, name="max_muscle_growth_index_combined")

# Optimize model
m.optimize()

if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of iron: {x1.X}")
    print(f"Milligrams of potassium: {x2.X}")
    print(f"Objective function value: {m.ObjVal}")
else:
    print("No optimal solution found")
