
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x1")  # milligrams of iron
    x2 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of potassium
    
    # Objective function
    model.setObjective(5*x1**2 + 4*x1*x2 + 3*x2**2 + 8*x1 + 7*x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(2*x1 + 9*x2 <= 109)
    model.addConstr(10*x1 <= 65)
    model.addConstr(10*x1 + 3*x2 <= 65)
    model.addConstr(x1**2 + x2**2 >= 48)
    model.addConstr(x1 + x2 >= 48)
    model.addConstr(10*x1 + 3*x2 >= 18)
    model.addConstr(-6*x1 + 5*x2 >= 0)
    model.addConstr(x1 + x2 <= 56)
    model.addConstr(10*x1 + 3*x2 <= 55)
    
    # Solve the model
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of iron: {x1.varValue}")
        print(f"Milligrams of potassium: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

optimize_problem()
