
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
eggs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="eggs")
granola_bars = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="granola_bars")
steaks = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="steaks")

# Set objective function
m.setObjective(1.95 * green_beans + 9.65 * eggs + 1.72 * granola_bars + 4.64 * steaks, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * eggs + 6 * granola_bars >= 10)
m.addConstr(4 * green_beans + 4 * eggs >= 5)
m.addConstr(4 * eggs + 3 * steaks >= 15)
m.addConstr(4 * green_beans + 4 * eggs + 6 * granola_bars + 3 * steaks >= 15)
m.addConstr(7 * green_beans + 2 * granola_bars >= 23)
m.addConstr(7 * green_beans + 7 * eggs + 5 * steaks >= 23)
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars >= 23)
m.addConstr(7 * green_beans + 7 * eggs + 5 * steaks >= 14)
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars >= 14)
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars + 5 * steaks >= 14)
m.addConstr(4 * granola_bars + 3 * steaks >= 16)
m.addConstr(2 * eggs + 4 * granola_bars >= 6)
m.addConstr(4 * green_beans + 4 * granola_bars >= 13)
m.addConstr(2 * eggs + 3 * steaks >= 9)
m.addConstr(4 * green_beans + 2 * eggs + 4 * granola_bars + 3 * steaks >= 9)
m.addConstr(4 * green_beans + 5 * eggs >= 7)
m.addConstr(4 * green_beans + 6 * granola_bars >= 7)
m.addConstr(5 * eggs + 6 * steaks >= 7)
m.addConstr(5 * eggs + 6 * granola_bars >= 20)
m.addConstr(4 * green_beans + 5 * eggs + 6 * steaks >= 13)
m.addConstr(4 * green_beans + 5 * eggs + 6 * granola_bars + 6 * steaks >= 13)
m.addConstr(8 * green_beans + 8 * steaks >= 7)
m.addConstr(8 * green_beans + 6 * granola_bars >= 7)
m.addConstr(6 * granola_bars + 8 * steaks >= 14)
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 12)
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 12)
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 12)
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 10)
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 10)
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 10)
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars >= 9)
m.addConstr(8 * green_beans + 5 * eggs + 8 * steaks >= 9)
m.addConstr(5 * eggs + 6 * granola_bars + 8 * steaks >= 9)
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars + 8 * steaks >= 9)
m.addConstr(-3 * green_beans + 6 * eggs >= 0)
m.addConstr(8 * green_beans - 4 * granola_bars >= 0)
m.addConstr(4 * green_beans + 4 * eggs <= 63)
m.addConstr(7 * green_beans + 5 * steaks <= 95)
m.addConstr(2 * granola_bars + 5 * steaks <= 32)
m.addConstr(7 * green_beans + 2 * granola_bars <= 26)
m.addConstr(7 * green_beans + 7 * eggs <= 94)
m.addConstr(7 * green_beans + 7 * eggs + 2 * granola_bars <= 74)
m.addConstr(2 * eggs + 3 * steaks <= 26)
m.addConstr(4 * green_beans + 3 * steaks <= 67)
m.addConstr(2 * eggs + 4 * granola_bars <= 43)
m.addConstr(4 * green_beans + 2 * eggs <= 57)
m.addConstr(4 * granola_bars + 3 * steaks <= 20)
m.addConstr(2 * eggs + 4 * granola_bars + 3 * steaks <= 56)
m.addConstr(5 * eggs + 6 * steaks <= 38)
m.addConstr(5 * eggs + 6 * granola_bars <= 22)
m.addConstr(6 * granola_bars + 6 * steaks <= 25)
m.addConstr(5 * eggs + 6 * granola_bars + 6 * steaks <= 28)
m.addConstr(4 * green_beans + 6 * granola_bars + 6 * steaks <= 58)
m.addConstr(8 * green_beans + 6 * granola_bars + 8 * steaks <= 29)
m.addConstr(8 * green_beans + 5 * eggs + 6 * granola_bars <= 46)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

