
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="grams_of_fiber")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="milligrams_of_potassium")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="milligrams_of_magnesium")


    # Set objective function
    m.setObjective(5*x0 + 1*x1 + 1*x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8.44*x0 + 6.36*x2 >= 69, "c0")
    m.addConstr(8.9*x1 + 6.36*x2 >= 37, "c1")
    m.addConstr(8.44*x0 + 8.9*x1 + 6.36*x2 >= 37, "c2")
    m.addConstr(2.94*x1 + 3.65*x2 >= 56, "c3")
    m.addConstr(6.43*x0 + 2.94*x1 >= 49, "c4")
    m.addConstr(6.43*x0 + 2.94*x1 + 3.65*x2 >= 49, "c5")
    m.addConstr(0.91*x0 + 4.62*x1 >= 33, "c6")
    m.addConstr(0.91*x0 + 4.62*x1 + 8.97*x2 >= 33, "c7")
    m.addConstr(0.9*x0 + 6.06*x1 >= 50, "c8")
    m.addConstr(0.9*x0 + 8.69*x2 >= 56, "c9")
    m.addConstr(6.06*x1 + 8.69*x2 >= 62, "c10")
    m.addConstr(0.9*x0 + 6.06*x1 + 8.69*x2 >= 62, "c11")
    m.addConstr(4.96*x0 + 6.79*x2 >= 17, "c12")
    m.addConstr(4.96*x0 + 7.58*x1 + 6.79*x2 >= 17, "c13")
    m.addConstr(-2*x1 + 9*x2 >= 0, "c14")
    m.addConstr(-6*x0 + 3*x1 >= 0, "c15")
    m.addConstr(2.94*x1 + 3.65*x2 <= 229, "c16")
    m.addConstr(6.43*x0 + 2.94*x1 <= 200, "c17")
    m.addConstr(7.58*x1 + 6.79*x2 <= 97, "c18")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('grams_of_fiber:', x0.x)
        print('milligrams_of_potassium:', x1.x)
        print('milligrams_of_magnesium:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
