
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # grams of fiber
x2 = m.addVar(name="x2", vtype=gurobi.GRB.INTEGER)  # milligrams of potassium
x3 = m.addVar(name="x3")  # milligrams of magnesium

# Objective function: Minimize 5 * x1 + x2 + x3
m.setObjective(5 * x1 + x2 + x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(8.44 * x1 <= 242)
m.addConstr(6.43 * x1 <= 232)
m.addConstr(0.91 * x1 <= 177)
m.addConstr(0.9 * x1 <= 229)
m.addConstr(4.96 * x1 <= 102)

m.addConstr(8.9 * x2 <= 242)
m.addConstr(2.94 * x2 <= 232)
m.addConstr(4.62 * x2 <= 177)
m.addConstr(6.06 * x2 <= 229)
m.addConstr(7.58 * x2 <= 102)

m.addConstr(6.36 * x3 <= 242)
m.addConstr(3.65 * x3 <= 232)
m.addConstr(8.97 * x3 <= 177)
m.addConstr(8.69 * x3 <= 229)
m.addConstr(6.79 * x3 <= 102)

m.addConstr(8.44 * x1 + 6.36 * x3 >= 69)
m.addConstr(8.9 * x2 + 6.36 * x3 >= 37)
m.addConstr(8.44 * x1 + 8.9 * x2 + 6.36 * x3 >= 37)

m.addConstr(2.94 * x2 + 3.65 * x3 >= 56)
m.addConstr(6.43 * x1 + 2.94 * x2 >= 49)
m.addConstr(6.43 * x1 + 2.94 * x2 + 3.65 * x3 >= 49)

m.addConstr(0.91 * x1 + 4.62 * x2 >= 33)
m.addConstr(0.91 * x1 + 4.62 * x2 + 8.97 * x3 >= 33)

m.addConstr(0.9 * x1 + 6.06 * x2 >= 50)
m.addConstr(0.9 * x1 + 8.69 * x3 >= 56)
m.addConstr(6.06 * x2 + 8.69 * x3 >= 62)
m.addConstr(0.9 * x1 + 6.06 * x2 + 8.69 * x3 >= 62)

m.addConstr(4.96 * x1 + 6.79 * x3 >= 17)
m.addConstr(4.96 * x1 + 7.58 * x2 + 6.79 * x3 >= 17)

m.addConstr(-2 * x2 + 9 * x3 >= 0)
m.addConstr(-6 * x1 + 3 * x2 >= 0)

m.addConstr(2.94 * x2 + 3.65 * x3 <= 229)
m.addConstr(6.43 * x1 + 2.94 * x2 <= 200)
m.addConstr(7.58 * x2 + 6.79 * x3 <= 97)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objval)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
