
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="strips_of_bacon", lb=-gurobi.GRB.INFINITY)
    x2 = model.addVar(name="knishes", lb=-gurobi.GRB.INFINITY)
    x3 = model.addVar(name="chicken_breasts", lb=-gurobi.GRB.INFINITY)
    x4 = model.addVar(name="kale_salads", lb=0, type=gurobi.GRB.INTEGER)
    x5 = model.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY)
    x6 = model.addVar(name="cherry_pies", lb=0, type=gurobi.GRB.INTEGER)
    x7 = model.addVar(name="potatoes", lb=-gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(3*x1 + 7*x2 + x3 + 6*x4 + x5 + 7*x6 + x7, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11*x1 + 7*x7 >= 20)
    model.addConstr(4*x4 + 4*x6 >= 22)
    model.addConstr(2*x2 + 4*x6 >= 14)
    model.addConstr(11*x1 + 4*x6 >= 14)
    model.addConstr(2*x2 + 7*x7 >= 10)
    model.addConstr(2*x3 + 4*x6 >= 19)
    model.addConstr(11*x1 + 4*x4 + 7*x7 >= 20)
    model.addConstr(2*x3 + 6*x4 + 6*x5 >= 20)
    model.addConstr(11*x1 + x3 + 4*x6 >= 20)
    model.addConstr(11*x1 + 2*x2 + 6*x5 >= 20)
    model.addConstr(11*x1 + 2*x2 + 4*x4 >= 20)
    model.addConstr(4*x4 + 6*x5 + 4*x6 >= 20)
    model.addConstr(11*x1 + x3 + 4*x4 >= 20)
    model.addConstr(11*x1 + 6*x5 + 4*x6 >= 20)
    model.addConstr(2*x2 + x3 + 7*x7 >= 20)
    model.addConstr(2*x2 + x3 + 4*x4 >= 20)
    model.addConstr(11*x1 + 4*x4 + 7*x7 >= 25)
    model.addConstr(2*x3 + 6*x4 + 6*x5 >= 25)
    model.addConstr(11*x1 + x3 + 4*x6 >= 25)
    model.addConstr(11*x1 + 2*x2 + 6*x5 >= 25)
    model.addConstr(11*x1 + 2*x2 + 4*x4 >= 25)
    model.addConstr(4*x4 + 6*x5 + 4*x6 >= 25)
    model.addConstr(11*x1 + x3 + 4*x4 >= 25)
    model.addConstr(11*x1 + 6*x5 + 4*x6 >= 25)
    model.addConstr(2*x2 + x3 + 7*x7 >= 25)
    model.addConstr(2*x2 + x3 + 4*x4 >= 25)
    model.addConstr(6*x6 - 8*x7 >= 0)
    model.addConstr(10*x2 - 2*x4 >= 0)
    model.addConstr(4*x4 + 4*x6 <= 155)
    model.addConstr(2*x3 + 6*x5 + 7*x7 <= 129)
    model.addConstr(11*x1 + 2*x2 + 7*x7 <= 30)
    model.addConstr(2*x2 + 4*x4 + 7*x7 <= 98)
    model.addConstr(2*x3 + 4*x4 + 4*x6 <= 66)
    model.addConstr(11*x1 + 6*x5 + 7*x7 <= 96)
    model.addConstr(11*x1 + x3 + 4*x6 <= 75)
    model.addConstr(x3 + 4*x6 + 7*x7 <= 165)
    model.addConstr(2*x2 + x3 + 6*x5 <= 139)
    model.addConstr(11*x1 + 4*x4 + 7*x7 <= 98)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Strips of bacon: ", x1.varValue)
        print("Knishes: ", x2.varValue)
        print("Chicken breasts: ", x3.varValue)
        print("Kale salads: ", x4.varValue)
        print("Chicken thighs: ", x5.varValue)
        print("Cherry pies: ", x6.varValue)
        print("Potatoes: ", x7.varValue)
    else:
        print("No solution found")

optimization_problem()
