
import gurobipy as gp

# Create a new model
model = gp.Model("optimize_work_hours")

# Create variables
bobby_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bobby_hours")
hank_hours = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="hank_hours")


# Set objective function
model.setObjective(2 * bobby_hours + 9 * hank_hours, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * bobby_hours + 5 * hank_hours >= 14, "combined_score_min")
model.addConstr(10 * bobby_hours - 9 * hank_hours >= 0, "work_ratio")
model.addConstr(6 * bobby_hours + 5 * hank_hours <= 39, "combined_score_max")


# Optimize model
model.optimize()

# Check if a solution was found
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Bobby's hours: {bobby_hours.x}")
    print(f"  Hank's hours: {hank_hours.x}")
    print(f"  Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

