
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Set the objective function
m.setObjective(2*x1 + 9*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x1 + 5*x2 >= 14, "Total_Organization_Score_Min")
m.addConstr(10*x1 - 9*x2 >= 0, "Linear_Inequality_Constraint")
m.addConstr(6*x1 + 5*x2 <= 39, "Upper_Bound_Total_Organization_Score")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Bobby: {x1.x}")
    print(f"Hours worked by Hank: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
