
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(lb=0, name="hours_worked_by_Bobby")  # hours worked by Bobby
x2 = model.addVar(lb=0, name="hours_worked_by_Hank")  # hours worked by Hank

# Define the objective function
model.setObjective(2*x1 + 9*x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6*x1 + 5*x2 >= 14, name="org_score_min")
model.addConstr(10*x1 - 9*x2 >= 0, name="hours_worked_constraint")
model.addConstr(6*x1 + 5*x2 <= 39, name="org_score_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Bobby: {x1.varValue}")
    print(f"Hours worked by Hank: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
