
import gurobipy as gp

# Create a new model
model = gp.Model("Supplement_Optimization")

# Create variables
vitamin_c = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
vitamin_b2 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b2")
magnesium = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="magnesium")
potassium = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potassium")
vitamin_b7 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")
iron = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="iron")


# Set objective function
model.setObjective(7*vitamin_c*vitamin_b2 + 8*vitamin_c*magnesium + 8*vitamin_c*vitamin_b7 + 9*vitamin_c*iron + 9*vitamin_b2*potassium + 1*magnesium*vitamin_b7 + 8*potassium*vitamin_b7 + 7*vitamin_b7**2 + 7*iron**2 + 2*vitamin_c + 5*vitamin_b2 + 5*magnesium, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(vitamin_c + 7*vitamin_b2 + 16*magnesium + 26*potassium + 24*vitamin_b7 + 13*iron <= 401, "c0")
model.addConstr(19*vitamin_c + 12*vitamin_b2 + 25*magnesium + 14*potassium + 24*vitamin_b7 + 3*iron <= 281, "c1")
model.addConstr(17*vitamin_c + 11*vitamin_b2 + 11*magnesium + 24*potassium + 16*vitamin_b7 + 14*iron <= 393, "c2")

# ... (add the rest of your constraints here based on the JSON output)

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Vitamin C:', vitamin_c.x)
    print('Vitamin B2:', vitamin_b2.x)
    print('Magnesium:', magnesium.x)
    print('Potassium:', potassium.x)
    print('Vitamin B7:', vitamin_b7.x)
    print('Iron:', iron.x)

elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print("Model status:", model.status)

