
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_C")
x1 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B2")
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, name="magnesium")
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, name="potassium")
x4 = model.addVar(lb=-gurobi.GRB.INFINITY, name="vitamin_B7")
x5 = model.addVar(lb=-gurobi.GRB.INFINITY, name="iron")

# Set bounds for variables based on given constraints
model.addConstr(x0 >= 1, name="cognitive_vitamin_C")
model.addConstr(x1 >= 7, name="cognitive_vitamin_B2")
model.addConstr(x2 >= 16, name="cognitive_magnesium")
model.addConstr(x3 >= 26, name="cognitive_potassium")
model.addConstr(x4 >= 24, name="cognitive_vitamin_B7")
model.addConstr(x5 >= 13, name="cognitive_iron")

# Objective function
model.setObjective(7*x0*x1 + 8*x0*x2 + 8*x0*x4 + 9*x0*x5 + 9*x1*x3 + x2*x4 + 8*x3*x4 + 7*x4**2 + 7*x5**2 + 2*x0 + 5*x1 + 5*x2, gurobi.GRB.MINIMIZE)

# Add other constraints
model.addConstr(x1**2 + x2**2 >= 27)
model.addConstr(x2 + x4 >= 61)
model.addConstr(x0 + x3 >= 36)

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
    print("x4: ", x4.varValue)
    print("x5: ", x5.varValue)
else:
    print("No solution found")
