
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x = m.addVars(7, lb=0, vtype=GRB.CONTINUOUS, name=["John", "Peggy", "Paul", "Bobby", "Mary", "Laura", "Jean"])


# Set objective function
m.setObjective(3*x[0]*x[0] + 4*x[1]*x[4] + 3*x[2]*x[4] + 4*x[2]*x[5] + 7*x[3]*x[5] + x[4]*x[5] + 3*x[3], GRB.MAXIMIZE)

# Add constraints
m.addConstr(22*x[0] <= 906)
m.addConstr(17*x[1] <= 906)
m.addConstr(4*x[2] <= 906)
m.addConstr(29*x[3] <= 906)
m.addConstr(18*x[4] <= 906)
m.addConstr(15*x[5] <= 906)
m.addConstr(22*x[6] <= 906)
m.addConstr(-10*x[0]*x[0] + 10*x[1]*x[1] >= 0)
m.addConstr(29*x[3]*x[3] + 18*x[4]*x[4] <= 385)
m.addConstr(17*x[1]*x[1] + 22*x[6]*x[6] <= 449)
m.addConstr(17*x[1] + 18*x[4] <= 432)
m.addConstr(17*x[1] + 4*x[2] <= 855)
m.addConstr(17*x[1]*x[1] + 29*x[3]*x[3] <= 264)
m.addConstr(22*x[0]*x[0] + 18*x[4]*x[4] <= 364)
m.addConstr(18*x[4] + 15*x[5] <= 283)
m.addConstr(4*x[2] + 22*x[6] <= 363)
m.addConstr(4*x[2] + 18*x[4] <= 653)
m.addConstr(22*x[0] + 15*x[5] <= 253)
m.addConstr(22*x[0] + 4*x[2] <= 690)
m.addConstr(22*x[0] + 17*x[1] <= 300)
m.addConstr(22*x[0] + 22*x[6] <= 279)
m.addConstr(18*x[4]*x[4] + 22*x[6]*x[6] <= 527)
m.addConstr(22*x[0] + 29*x[3] <= 199)
m.addConstr(22*x[0]*x[0] + 15*x[5]*x[5] + 22*x[6]*x[6] <= 571)
m.addConstr(17*x[1] + 4*x[2] + 15*x[5] <= 527)
m.addConstr(22*x[0] + 17*x[1] + 22*x[6] <= 650)
m.addConstr(4*x[2] + 18*x[4] + 15*x[5] <= 862)
m.addConstr(29*x[3] + 15*x[5] + 22*x[6] <= 881)
m.addConstr(22*x[0] + 17*x[1] + 15*x[5] <= 561)
m.addConstr(17*x[1] + 4*x[2] + 18*x[4] <= 817)
m.addConstr(22*x[0] + 4*x[2] + 15*x[5] <= 402)
m.addConstr(17*x[1] + 29*x[3] + 22*x[6] <= 698)
m.addConstr(22*x[0] + 29*x[3] + 22*x[6] <= 380)
m.addConstr(4*x[2] + 29*x[3] + 18*x[4] <= 824)
m.addConstr(29*x[3] + 18*x[4] + 15*x[5] <= 699)
m.addConstr(17*x[1] + 29*x[3] + 18*x[4] <= 271)
m.addConstr(4*x[2] + 29*x[3] + 22*x[6] <= 899)
m.addConstr(4*x[2] + 29*x[3] + 15*x[5] <= 199)
m.addConstr(22*x[0] + 4*x[2] + 29*x[3] <= 225)
m.addConstr(22*x[0] + 17*x[1] + 4*x[2] + 29*x[3] + 18*x[4] + 15*x[5] + 22*x[6] <= 225)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

