
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x1 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_John')
x2 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Peggy')
x3 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Paul')
x4 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Bobby')
x5 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Mary')
x6 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Laura')
x7 = m.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name='hours_worked_by_Jean')

# Objective function
m.setObjective(3*x1**2 + 4*x2*x5 + 3*x3*x5 + 4*x3*x6 + 7*x4*x6 + x5*x6 + 3*x4, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(-10*x1**2 + 10*x2**2 >= 0)
m.addConstr(x4**2 + x5**2 <= 385)
m.addConstr(x2**2 + x7**2 <= 449)
m.addConstr(x2 + x5 <= 432)
m.addConstr(x2 + x3 <= 855)
m.addConstr(x2**2 + x4**2 <= 264)
m.addConstr(x1**2 + x5**2 <= 364)
m.addConstr(x5 + x6 <= 283)
m.addConstr(x3 + x7 <= 363)
m.addConstr(x3 + x5 <= 653)
m.addConstr(x1 + x6 <= 253)
m.addConstr(x1 + x3 <= 690)
m.addConstr(x1 + x2 <= 300)
m.addConstr(x1 + x7 <= 279)
m.addConstr(x5**2 + x7**2 <= 527)
m.addConstr(x1 + x4 <= 199)
m.addConstr(x1**2 + x6**2 + x7**2 <= 571)
m.addConstr(x2 + x3 + x6 <= 527)
m.addConstr(x1 + x2 + x7 <= 650)
m.addConstr(x3 + x5 + x6 <= 862)
m.addConstr(x4 + x6 + x7 <= 881)
m.addConstr(x1 + x2 + x6 <= 561)
m.addConstr(x2 + x3 + x5 <= 817)
m.addConstr(x1 + x3 + x6 <= 402)
m.addConstr(x2 + x4 + x7 <= 698)
m.addConstr(x1 + x4 + x7 <= 380)
m.addConstr(x3 + x4 + x5 <= 824)
m.addConstr(x4 + x5 + x6 <= 699)
m.addConstr(x2 + x4 + x5 <= 271)
m.addConstr(x3 + x4 + x7 <= 899)
m.addConstr(x3 + x4 + x6 <= 199)
m.addConstr(x1 + x3 + x4 <= 225)
m.addConstr(x1 + x2 + x3 + x4 + x5 + x6 + x7 <= 225)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print('Objective: ', m.objVal)
    print('Hours worked by John: ', x1.varValue)
    print('Hours worked by Peggy: ', x2.varValue)
    print('Hours worked by Paul: ', x3.varValue)
    print('Hours worked by Bobby: ', x4.varValue)
    print('Hours worked by Mary: ', x5.varValue)
    print('Hours worked by Laura: ', x6.varValue)
    print('Hours worked by Jean: ', x7.varValue)
else:
    print('No solution found')
