
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pickles = m.addVar(lb=0, name="pickles")
oreos = m.addVar(lb=0, name="oreos")

# Set objective function
m.setObjective(6.69*pickles**2 + 1.02*oreos**2 + 7.54*pickles + 3.56*oreos, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(16*pickles + 1*oreos >= 26, "iron_req")
m.addConstr(3*pickles**2 + 10*oreos**2 >= 31, "calcium_req_sq")
m.addConstr(3*pickles + 10*oreos >= 31, "calcium_req")
m.addConstr(20*pickles + 21*oreos >= 8, "carbs_req")
m.addConstr(7*pickles - 7*oreos >= 0, "pickles_oreos_relation")
m.addConstr(16*pickles**2 + 1*oreos**2 <= 57, "iron_limit_sq")
m.addConstr(3*pickles + 10*oreos <= 73, "calcium_limit")
m.addConstr(20*pickles + 21*oreos <= 33, "carbs_limit")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('pickles:', pickles.x)
    print('oreos:', oreos.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

