
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="pickles", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="oreos", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(6.69 * x1**2 + 1.02 * x2**2 + 7.54 * x1 + 3.56 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(16 * x1 + x2 >= 26, name="iron_min")
    model.addConstr(3 * x1 + 10 * x2 >= 31, name="calcium_min")
    model.addConstr(20 * x1 + 21 * x2 >= 8, name="carbohydrates_min")
    model.addConstr(7 * x1 - 7 * x2 >= 0, name="pickles_oreos_relation")
    model.addConstr(16 * x1 + x2 <= 57, name="iron_max")
    model.addConstr(3 * x1 + 10 * x2 <= 73, name="calcium_max")
    model.addConstr(20 * x1 + 21 * x2 <= 33, name="carbohydrates_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Pickles: ", x1.varValue)
        print("Oreos: ", x2.varValue)
    else:
        print("No solution found")

optimize_problem()
