
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    vitamin_c = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_c")
    vitamin_a = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_a")
    vitamin_b7 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_b7")


    # Set objective function
    m.setObjective(3.78 * vitamin_c + 3.66 * vitamin_a + 3.88 * vitamin_b7, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2 * vitamin_c + 3 * vitamin_a + 3 * vitamin_b7 <= 52, "kidney_support_index")
    m.addConstr(vitamin_c + 4 * vitamin_a + 7 * vitamin_b7 <= 113, "muscle_growth_index")
    m.addConstr(2 * vitamin_c + 3 * vitamin_a >= 12, "combined_kidney_support_1")
    m.addConstr(4 * vitamin_a + 7 * vitamin_b7 >= 35, "combined_muscle_growth_1")
    m.addConstr(3 * vitamin_a + 3 * vitamin_b7 <= 48, "combined_kidney_support_2")
    m.addConstr(2 * vitamin_c + 3 * vitamin_a <= 35, "combined_kidney_support_3")
    m.addConstr(2 * vitamin_c + 3 * vitamin_a + 3 * vitamin_b7 <= 35, "combined_kidney_support_4")
    m.addConstr(vitamin_c + 4 * vitamin_a <= 112, "combined_muscle_growth_2")
    m.addConstr(vitamin_c + 7 * vitamin_b7 <= 79, "combined_muscle_growth_3")
    m.addConstr(vitamin_c + 4 * vitamin_a + 7 * vitamin_b7 <= 79, "combined_muscle_growth_4")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_c:', vitamin_c.x)
        print('vitamin_a:', vitamin_a.x)
        print('vitamin_b7:', vitamin_b7.x)

    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
