
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin C", vtype=gurobi.GRB.CONTINUOUS)
    x1 = model.addVar(lb=0, name="milligrams of vitamin A", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams of vitamin B7", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function
    model.setObjective(3.78 * x0 + 3.66 * x1 + 3.88 * x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x0 == 2, name="kidney_support_index_vitamin_C")
    model.addConstr(2 * x0 + 3 * x1 >= 12, name="kidney_support_index_vitamin_C_and_A")
    model.addConstr(4 * x1 + 7 * x2 >= 35, name="muscle_growth_index_vitamin_A_and_B7")
    model.addConstr(3 * x1 + 3 * x2 <= 48, name="kidney_support_index_vitamin_A_and_B7")
    model.addConstr(2 * x0 + 3 * x1 <= 35, name="kidney_support_index_vitamin_C_and_A_max")
    model.addConstr(2 * x0 + 3 * x1 + 3 * x2 <= 35, name="kidney_support_index_all")
    model.addConstr(x0 + 4 * x1 <= 112, name="muscle_growth_index_vitamin_C_and_A")
    model.addConstr(x0 + 7 * x2 <= 79, name="muscle_growth_index_vitamin_C_and_B7")
    model.addConstr(x0 + 4 * x1 + 7 * x2 <= 79, name="muscle_growth_index_all")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin C: {x0.varValue}")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Milligrams of vitamin B7: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
