
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
sashimi = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="sashimi")
pasta = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="bowls_of_pasta")
knishes = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="knishes")
hamburgers = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="hamburgers")
chicken_thighs = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="chicken_thighs")


# Set objective function
m.setObjective(7.13*sashimi**2 + 5.11*sashimi*pasta + 8.45*sashimi*hamburgers + 2.82*pasta*knishes + 3.6*pasta*hamburgers + 8.6*pasta*chicken_thighs + 9.18*knishes**2 + 5.24*knishes*hamburgers + 7.54*hamburgers + 2.54*chicken_thighs, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(9*sashimi + 15*knishes + 7*chicken_thighs >= 58)
m.addConstr(9*sashimi + 19*pasta + 7*chicken_thighs >= 58)
m.addConstr(19*pasta**2 + 15*knishes**2 + 7*chicken_thighs**2 >= 58)
# ... (add all other constraints similarly)

# Resource constraints
r0 = 9*sashimi + 19*pasta + 15*knishes + 13*hamburgers + 7*chicken_thighs
r1 = 7*sashimi + 14*pasta + 4*knishes + 17*hamburgers + 13*chicken_thighs
r2 = 17*sashimi + 7*pasta + 12*knishes + 16*hamburgers + 18*chicken_thighs
r3 = 22*sashimi + 21*pasta + 15*knishes + 18*hamburgers + 4*chicken_thighs

m.addConstr(r0 <= 316)
m.addConstr(r1 <= 709)
m.addConstr(r2 <= 201)
m.addConstr(r3 <= 416)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

