
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
security_engineers = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
intrusion_analysts = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")


# Set objective function
m.setObjective(2 * security_engineers + 6 * intrusion_analysts, GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * security_engineers + 23 * intrusion_analysts >= 80, "min_latency")
m.addConstr(13 * security_engineers + 13 * intrusion_analysts >= 72, "min_cost")
m.addConstr(security_engineers - intrusion_analysts >= 0, "engineers_more_than_analysts")
m.addConstr(4 * security_engineers + 23 * intrusion_analysts <= 134, "max_latency")
m.addConstr(13 * security_engineers + 13 * intrusion_analysts <= 190, "max_cost")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Security Engineers: {security_engineers.x}")
    print(f"  Intrusion Analysts: {intrusion_analysts.x}")
    print(f"  Objective Value: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

