
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables to the model
x0 = m.addVar(vtype=GRB.INTEGER, name="security_engineers")
x1 = m.addVar(vtype=GRB.INTEGER, name="intrusion_analysts")

# Set the objective function
m.setObjective(2*x0 + 6*x1, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(4*x0 + 23*x1 >= 80, "minimum_latency")
m.addConstr(13*x0 + 13*x1 >= 72, "minimum_cost")
m.addConstr(x0 - x1 >= 0, "engineers_vs_analysts")
m.addConstr(4*x0 + 23*x1 <= 134, "maximum_latency")
m.addConstr(13*x0 + 13*x1 <= 190, "maximum_cost")

# Optimize the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Security Engineers: {x0.x}")
    print(f"Intrusion Analysts: {x1.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found.")
