
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="security_engineers", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="intrusion_analysts", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(2*x1 + 6*x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(4*x1 + 23*x2 >= 80, name="network_latency_min")
    model.addConstr(13*x1 + 13*x2 >= 72, name="cost_min")
    model.addConstr(x1 - x2 >= 0, name="security_engineers_vs_intrusion_analysts")
    model.addConstr(4*x1 + 23*x2 <= 134, name="network_latency_max")
    model.addConstr(13*x1 + 13*x2 <= 198, name="cost_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Security Engineers: {x1.varValue}")
        print(f"Intrusion Analysts: {x2.varValue}")
        print(f"Objective Function Value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
