
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B1")
    x1 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="calcium")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B3")
    x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B5")


    # Set objective function
    m.setObjective(7*x0 + 5*x1 + 8*x2 + 8*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 3*x1 + 11*x2 + 11*x3 <= 125, "c0")
    m.addConstr(1*x0 + 8*x1 + 3*x2 + 5*x3 <= 67, "c1")
    m.addConstr(11*x2 + 11*x3 >= 16, "c2")
    m.addConstr(8*x0 + 11*x3 >= 24, "c3")
    m.addConstr(8*x0 + 3*x1 + 11*x2 + 11*x3 >= 24, "c4")
    m.addConstr(8*x1 + 3*x2 >= 16, "c5")
    m.addConstr(1*x0 + 8*x1 + 3*x2 + 5*x3 >= 16, "c6")
    m.addConstr(-8*x1 + 10*x3 >= 0, "c7")
    m.addConstr(-3*x2 + 6*x3 >= 0, "c8")
    m.addConstr(-6*x1 + 4*x2 + 6*x3 >= 0, "c9")
    m.addConstr(8*x0 + 11*x2 + 11*x3 <= 98, "c10")
    m.addConstr(x0 + 8*x1 <= 23, "c11")
    m.addConstr(8*x1 + 5*x3 <= 27, "c12")
    m.addConstr(3*x2 + 5*x3 <= 40, "c13")
    m.addConstr(x0 + 5*x3 <= 48, "c14")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
