
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x0")  # milligrams of vitamin B1
x1 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, vtype=gurobi.GRB.INTEGER, name="x1")  # milligrams of calcium
x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x2")  # milligrams of vitamin B3
x3 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="x3")  # milligrams of vitamin B5

# Objective function
model.setObjective(7 * x0 + 5 * x1 + 8 * x2 + 8 * x3, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(8 * x0 <= 125)
model.addConstr(11 * x2 + 11 * x3 >= 16)
model.addConstr(8 * x0 + 11 * x3 >= 24)
model.addConstr(8 * x0 + 3 * x1 + 11 * x2 + 11 * x3 >= 24)
model.addConstr(8 * x1 + 3 * x2 >= 16)
model.addConstr(x0 + 8 * x1 + 3 * x2 + 5 * x3 >= 16)
model.addConstr(-8 * x1 + 10 * x3 >= 0)
model.addConstr(-3 * x2 + 6 * x3 >= 0)
model.addConstr(-6 * x1 + 4 * x2 + 6 * x3 >= 0)
model.addConstr(8 * x0 + 11 * x2 + 11 * x3 <= 98)
model.addConstr(x0 + 8 * x1 <= 23)
model.addConstr(8 * x1 + 5 * x3 <= 27)
model.addConstr(3 * x2 + 5 * x3 <= 40)
model.addConstr(x0 + 5 * x3 <= 48)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
