
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="peanutbutter sandwiches")
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="milkshakes")


    # Set objective function
    m.setObjective(5*x0**2 + 9*x0*x1 + 3*x1**2 + 6*x0 + 4*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(0.83*x0 + 0.68*x1 >= 55, "fiber_constraint1")
    m.addConstr(6.28*x0 + 10.37*x1 >= 18, "tastiness_constraint1")
    m.addConstr(3*x0 - x1 >= 0, "constraint3")
    m.addConstr(0.83*x0**2 + 0.68*x1**2 >= 55, "fiber_constraint2")
    m.addConstr(0.83*x0 + 0.68*x1 <= 100, "fiber_constraint3")
    m.addConstr(6.28*x0 + 10.37*x1 <= 73, "tastiness_constraint2")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('peanutbutter sandwiches: %g' % x0.x)
        print('milkshakes: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
