
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="peanutbutter_sandwiches", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name="milkshakes", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    
    # Objective function
    model.setObjective(5*x1**2 + 9*x1*x2 + 3*x2**2 + 6*x1 + 4*x2, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(0.83*x1 + 0.68*x2 >= 55, name="fiber_min")
    model.addConstr(x1**2 + x2**2 >= 55, name="fiber_min_squared")
    model.addConstr(6.28*x1 + 10.37*x2 >= 18, name="tastiness_min")
    model.addConstr(6.28*x1 + 10.37*x2 <= 73, name="tastiness_max_1")
    model.addConstr(6.28*x1 + 10.37*x2 <= 82, name="tastiness_max_2")
    model.addConstr(3*x1 - x2 >= 0, name="peanutbutter_milkshakes_ratio")
    model.addConstr(0.83*x1 + 0.68*x2 <= 100, name="fiber_max")
    model.addConstr(0.83*x1 <= 143, name="fiber_peanutbutter_max")
    
    # Optimize
    model.optimize()
    
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Peanutbutter sandwiches: {x1.varValue}")
        print(f"Milkshakes: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
